#include "Main2.h"

void CCamera::Position_Camera(float pos_x,  float pos_y,  float pos_z,
							  float view_x, float view_y, float view_z,
							  float up_x,   float up_y,   float up_z)
{
	mPos	= tVector3(pos_x,  pos_y,  pos_z );
	mView	= tVector3(view_x, view_y, view_z);
	mUp		= tVector3(up_x,   up_y,   up_z  );
}


void CCamera::Move_Camera(float speed)
{
	tVector3 vVector = mView - mPos;
	mPos.x  = mPos.x  + vVector.x * speed;
	mPos.z  = mPos.z  + vVector.z * speed;
	mView.x = mView.x + vVector.x * speed;
	mView.z = mView.z + vVector.z * speed;
}

void CCamera::Strafe_Camera(float speed) //Strafe code of DOOM.
{
	tVector3 vVector = mView - mPos;
	if((GetKeyState(VK_LEFT) & 0x80) || (GetKeyState('A') & 0x80))
	{
		mPos.z = mPos.z + vVector.x * speed;
		mView.z = mView.z + vVector.x * speed;
		mPos.x = mPos.x - vVector.z * speed;
		mView.x = mView.x - vVector.z * speed;
	}
	if((GetKeyState(VK_RIGHT) & 0x80) || (GetKeyState('D') & 0x80))
	{
		mPos.z = mPos.z - vVector.x * speed;
		mView.z = mView.z - vVector.x * speed;
		mPos.x = mPos.x + vVector.z * speed;
		mView.x = mView.x + vVector.z * speed;
	}
}

void CCamera::Fly_Camera(float speed)
{
	tVector3 vVector = mView - mPos;
	mPos.y = mPos.y + vVector.y * speed;
	mView.y = mView.y + vVector.y * speed;
}

void CCamera::Rotate_View(float speed)
{
	tVector3 vVector = mView - mPos;

	mView.z = (float)(mPos.z + sin(speed)*vVector.x + cos(speed)*vVector.z);
	mView.x = (float)(mPos.x + cos(speed)*vVector.x - sin(speed)*vVector.z);
}


void CCamera::Mouse_Move(int wndWidth, int wndHeight)
{
	POINT mousePos;	
	int mid_x = wndWidth  >> 1;	
	int mid_y = wndHeight >> 1;	
	float angle_y  = 0.0f;				
	float angle_z  = 0.0f;							
	
	GetCursorPos(&mousePos);					
	
	if( (mousePos.x == mid_x) && (mousePos.y == mid_y) ) return;

	SetCursorPos(mid_x, mid_y);				

	angle_y = (float)( (mid_x - mousePos.x) ) / 1000;		
	angle_z = (float)( (mid_y - mousePos.y) ) / 1000;

	mView.y += angle_z * 2;

	if((mView.y - mPos.y) > 8)  mView.y = mPos.y + 8;
	if((mView.y - mPos.y) <-8)  mView.y = mPos.y - 8;
	
	Rotate_View(-angle_y);
}