#ifndef _MAIN_H
#define _MAIN_H

#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")
#pragma comment(lib, "glaux.lib")

#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include <gl\glaux.h>
#include <gl\glut.h>
#include <math.h>

#define CAMERASPEED	0.015f

typedef struct tVector3
{	
	tVector3() {}
	tVector3 (float new_x, float new_y, float new_z)
	{x = new_x; y = new_y; z = new_z;}
	tVector3 operator+(tVector3 vVector) {return tVector3(vVector.x+x, vVector.y+y, vVector.z+z);}
	tVector3 operator-(tVector3 vVector) {return tVector3(x-vVector.x, y-vVector.y, z-vVector.z);}
	tVector3 operator*(float number)	 {return tVector3(x*number, y*number, z*number);}
	tVector3 operator/(float number)	 {return tVector3(x/number, y/number, z/number);}
	float x, y, z;
}tVector3;

class CCamera 
{
	public:
		tVector3 mPos;	
		tVector3 mView;		
		tVector3 mUp;
		void Mouse_Move(int wndWidth, int wndHeight);
		void Move_Camera(float speed);
		void Strafe_Camera(float speed);
		void Rotate_View(float speed);
		void Position_Camera(float pos_x, float pos_y,float pos_z,
       				         float view_x, float view_y, float view_z,
				             float up_x,   float up_y,   float up_z);
};

extern	HDC			hDC;
extern	HGLRC		hRC;
extern	HWND		hWnd;
extern	HINSTANCE	hInstance;
void Keyboard_Input();
void Draw_Grid();
#endif