#include "main.h"

void Player::setPlayerPosition(float px, float py, float pz,
			       float vx, float vy, float vz)
{
	pPos = tVector3(px, py, pz);
	pView = tVector3(vx, vy, vz);
}
	
void Player::setHealth(int HP)
{
	//Object collision, player health checks...
}

int Player::getHealth()
{
	return HP;
}
	
void Player::movePlayer(float direction)
{
	tVector3 vVector = pView - pPos;

	pPos.x = pPos.x + vVector.x * direction;
	pPos.z = pPos.z + vVector.z * direction;
}

void Player::strafePlayer(float direction)
{
	tVector3 vVector = pView - pPos;

	pPos.z = pPos.z + vVector.x * direction;
	pPos.x = pPos.x - vVector.z * direction;
}

