#include "main.h"

Camera objCamera;
Player objPlayer;

SDL_Event event;

void drawCross()
{
        glColor3f(1.0, 1.0, 1.0);
        glPointSize(3.0);

        glBegin(GL_POINTS);
                glVertex3f(objCamera.mView.x, objCamera.mView.y, objCamera.mView.z);
        glEnd();
}

void drawGrid()
{
        for(float i = -500; i <= 500; i += 5)
        {
                glBegin(GL_LINES);
                        glColor3ub(150, 190, 150);
                        glVertex3f(-500, 0, i);
                        glVertex3f(500, 0, i);
                        glVertex3f(i, 0,-500);
                        glVertex3f(i, 0, 500);
                glEnd();
        }
}

void DrawScene(SDL_Surface *screen)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	gluLookAt(objCamera.mPos.x,  objCamera.mPos.y,  objCamera.mPos.z,
                  objCamera.mView.x, objCamera.mView.y, objCamera.mView.z,
                  objCamera.mUp.x,   objCamera.mUp.y,   objCamera.mUp.z);

	drawGrid();

	//Test.
	drawCross();
	//End test.

        glFlush();
	SDL_GL_SwapBuffers();			
}

void init()
{
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 32);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	SDL_EnableKeyRepeat(10, 30);

	glShadeModel(GL_SMOOTH);
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	SDL_ShowCursor(0);
		
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, 1280/1024, 0.1f, 100.0f);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	objCamera.setCameraPosition(0, 2.5f, 5,  0, 2.5f, 0,  0, 1, 0);
	objPlayer.setPlayerPosition(0, 2.5f, 5,  0, 2.5f, 0);
	objPlayer.setHealth(100);
}

void keyboardInput(float direction)
{
	Uint8 *keystate = SDL_GetKeyState(NULL);

        if(keystate[SDLK_w])
        {
                objCamera.moveCamera(+direction);
		objPlayer.movePlayer(+direction);
        }

        if(keystate[SDLK_s])
        {
                objCamera.moveCamera(-direction);
		objPlayer.movePlayer(-direction);
        }

	if(keystate[SDLK_a])
        {
                objCamera.strafeCamera(-direction);
		objPlayer.strafePlayer(-direction);
        }

        if(keystate[SDLK_d])
        {
                objCamera.strafeCamera(direction);
		objPlayer.strafePlayer(direction);
        }
}

int options = (SDL_FULLSCREEN|SDL_OPENGL);

int main(int argc, char *argv[])
{
	if(SDL_Init(SDL_INIT_AUDIO|SDL_INIT_VIDEO) < 0)
	{
  		cout << "Unable to init SDL: %s\n" << SDL_GetError() << endl;
  		exit(1);
  	}
	
	atexit(SDL_Quit);

  	SDL_Surface *screen;
	//Maybe calculate computer speed and check what resolution to use?
  	screen = SDL_SetVideoMode(1280,1024,32,options);
  
	if(screen == NULL)
	{
		cout << "Unable to set 1280x1024 video: %s\n" << SDL_GetError() << endl;
    		exit(1);
  	}
  
	int done = 0;

	init();

  	while(done == 0)
  	{
    		while(SDL_PollEvent(&event))
    		{
			if(event.type == SDL_QUIT) 
			{
				done = 1; 
			}
	
			if(event.type == SDL_KEYDOWN)
      			{
      				if(event.key.keysym.sym == SDLK_ESCAPE)
				{	
					done = 1;
				}
				
				keyboardInput(0.15f);
			}
		}
		objCamera.moveMouse();
    		DrawScene(screen);
	}

return 0;
}
