#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <SDL/SDL.h>
#include <iostream>
#include <math.h>

using namespace std;

typedef struct tVector3
{
        tVector3() {}
        tVector3 (float new_x, float new_y, float new_z)
        {x = new_x; y = new_y; z = new_z;}
        tVector3 operator+(tVector3 vVector) {return tVector3(vVector.x+x, vVector.y+y, vVector.z+z);}
        tVector3 operator-(tVector3 vVector) {return tVector3(x-vVector.x, y-vVector.y, z-vVector.z);}
        tVector3 operator*(float number)         {return tVector3(x*number, y*number, z*number);}
        tVector3 operator/(float number)         {return tVector3(x/number, y/number, z/number);}
        float x, y, z;
}tVector3;

class Camera
{
public:
        void setCameraPosition(float pos_x, float pos_y, float pos_z,
                               float view_x, float view_y, float view_z,
                               float up_x, float up_y, float up_z);

        void moveMouse();
        void moveCamera(float speed);
        void strafeCamera(float speed);
        void rotateCamera(float speed);

        tVector3 mPos;
        tVector3 mView;
        tVector3 mUp;
};

class Player
{
public:
        void setPlayerPosition(float px, float py, float pz,
                               float vx, float vy, float vz);

        void setHealth(int HP);
        int getHealth();

        void movePlayer(float direction);
        void strafePlayer(float direction);

        //void addVelocity(float xVel, float yVel, float zVel);

        tVector3 pPos;
        tVector3 pView;
        tVector3 pVel;
        int HP;
};
