#include "main.h"

Camera objCamera;

SDL_Event event;

void DrawScene(SDL_Surface *screen)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	gluLookAt(objCamera.mPos.x,  objCamera.mPos.y,  objCamera.mPos.z,
                  objCamera.mView.x, objCamera.mView.y, objCamera.mView.z,
                  objCamera.mUp.x,   objCamera.mUp.y,   objCamera.mUp.z);

    glFlush();
	SDL_GL_SwapBuffers();			
}

void init()
{
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 32);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	SDL_EnableKeyRepeat(10, 30);

	glShadeModel(GL_SMOOTH);
	glClearColor(0.0, 0.0, 1.0, 0.0);
	glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	SDL_ShowCursor(0);
		
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, 1280/1024, 0.1f, 100.0f);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	objCamera.setCameraPosition(0, 2.5f, 5,  0, 2.5f, 0,  0, 1, 0);
}

int options = (SDL_FULLSCREEN|SDL_OPENGL);

int main(int argc, char *argv[])
{
	if(SDL_Init(SDL_INIT_VIDEO) < 0)
	{
  		cout << "Unable to init SDL: %s\n" << SDL_GetError() << endl;
  		exit(1);
  	}
	
	atexit(SDL_Quit);

  	SDL_Surface *screen;
	//Maybe calculate computer speed and check what resolution to use?
  	screen = SDL_SetVideoMode(1280,1024,32,options);
  
	if(screen == NULL)
	{
		cout << "Unable to set 1280x1024 video: %s\n" << SDL_GetError() << endl;
    		exit(1);
  	}
  
	int done = 0;

	init();

  	while(done == 0)
  	{
    		while(SDL_PollEvent(&event))
    		{
			if(event.type == SDL_QUIT) 
			{
				done = 1; 
			}
	
			if(event.type == SDL_KEYDOWN)
      			{
      				if(event.key.keysym.sym == SDLK_ESCAPE)
				{	
					done = 1;
				}
			}
		}
    		DrawScene(screen);
	}

return 0;
}
